;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;  Microsoft Sidewinder Gamepad TSR
;;    Overlays int 15h subfunction 84h
;;    (C) 1997 Robert William Grubbs
;;    
;;  TSR Code is based on David Nugent's FUTIL TSR.  Thanks!
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;
; NOTE: MASM 5.10 or TASM 1.0 is required to assembly this program!
;       Earlier versions of MASM will NOT work.
;
; Provides TASM->MASM compatibility

ifdef ??version
	masm51
	quirks
endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Definitions/readability section
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CDSIG           equ 00911H              ; SIDEWTSR's signature

DOS		equ 021H		; DOS interrupt
TSR		equ 027H		; .COM TSR call

;;;;;;;;;;;;;;;;
;;
;; Start program
;;
;;;;;;;;;;;;;;;;

_code segment para public 'code'
	assume CS:_code
	org 100h			; .COM start

; Jump to install (which is unloaded on TSR)

start:
	jmp install

;
; Int 15H entry point
;
	even
Int_15:
	jmp SHORT parse

;
; SIDEWTSR data section
;

oldvec  dd 0                            ; Old INT 15H vector
        dw CDSIG                        ; SIDEWTSR id
OldVals dw                              ; Preserve old button status
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;      INT 15H handler
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

parse	PROC NEAR

        sti                             ; enable interrupts
        cmp ah,084h                     ; check for joystick call
        je SHORT IsJoy                  ; 
        jmp DWORD PTR CS:[oldvec]       ; if not joystick, use old handler
IsJoy:
        cmp dx,01H                      ; check subfunction
        je SHORT SubFunct1              ; check for axis call
        push bx                         ; preserve registers
        push cx
        ;dx=0  Carry=0  al=7(1a) 6(1b) 5(2a) 4(2b)

        mov cx,32                       ; timeout maximum
        SubF0Err:                       ;
        dec cx                          ; decriment timeout count
        jz SHORT SubF0TimeOut           ; test for timeout
        call SWStatus                   ; get sidewinder status
        jc SHORT SubF0Err               ; check for errors
        jmp SHORT Gotdata0              ; data is valid
        SubF0TimeOut:                   ;
        mov bx,CS:[OldVals]             ; use old status to cover timeout
        Gotdata0:                       ;
        mov CS:[OldVals],bx             ; preserve current data
                                        
        xor al,al                       ; clear output
        test bx,32                      ; Check sw button A
        jz SHORT NoButtonA              ;
        or al,128                       ; or in value for Joystick A, button 1
        NoButtonA:                      ;
        test bx,64
        jz SHORT NoButtonB
        or al,64
        NoButtonB:
        test bx,128
        jz SHORT NoButtonC
        or al,128
        NoButtonC:
        test bx,256
        jz SHORT NoButtonX
        or al,32
        NoButtonX:
        test bx,512
        jz SHORT NoButtonY
        or al,16
        NoButtonY:
        test bx,1024
        jz SHORT NoButtonZ
        or al,32
        NoButtonZ:
        pop cx                          ;restore registers
        pop bx
        clc                             ;indicate success
        iret
SubFunct1:
        ;dx=1  Carry=0  ax=x1 bx=x2

        mov cx,32
        SubF1Err:
        dec cx
        jz SHORT SubF1TimeOut
        call SWStatus
        jc SHORT SubF1Err
        jmp SHORT Gotdata1
        SubF1TimeOut:
        mov bx,CS:[OldVals]
        Gotdata1:
        mov CS:[OldVals],bx
         
        mov cx,bx
        mov ax,120
        mov bx,120
        test cx,2
        jz SHORT NoButtonUp
        mov bx,250
        NoButtonUp:
        test cx,4
        jz SHORT NoButtonDn
        mov bx,5
        NoButtonDn:
        test cx,8
        jz SHORT NoButtonRt
        mov ax,250
        NoButtonRt:
        test cx,16
        jz SHORT NoButtonLt
        mov ax,5
        NoButtonLt:
        xor cx,cx
        xor dx,dx
	iret				; Return to user

parse	ENDP

;The main subroutine;  this is the important one;  bow down before it
;IN: none
;Out: bx=buttons  (bit 0=null 1=up 2=dn 3=rt 4=lt 5=A 6=B 7=C 8=X)
;                 (9=Y 10=Z 11=L 12=R 13=St 14=M 15=Parity)
;No registers destroyed (besides BX, of course)
gDump db 100h DUP (0)   ;SW Status dump buffer (space for 256 bytes, uses 200)
bDump db 10h DUP (0)    ;buffer to hold button data for mode B
SWStatus PROC NEAR
  push ax
  push cx
  push dx
  push si
  push di
  push bp

  ;implementation note:  interrupt processing may mess up the SW data,
  ; so it may be necessary to disable interrupts during the SW dump below
  ;I havn't had problems so far, but just in case, I thought I'd warn you...

  mov cx,200                  ;dump buffer fill size
  mov bx,0                    ;initial dump pointer
  mov dx,0201h                ;joystick port
  ;cli                         ;uncomment to disble interrupts
  GetSWDataLoop:              ;
  out dx,al                   ;trigger joystick port
  in al,dx                    ;read SW status byte
  mov cs:[gDump+bx],al        ;dump status byte
  inc bx                      ;increment dump pointer
  loop GetSWDataLoop          ;get next status byte (quickly)
  ;sti                         ;uncomment to disble interrupts

  mov cx,0                    ;tick count
  mov si,1                    ;initialize output mask
  mov bx,0                    ;initialize output
  mov di,0                    ;initialize input pointer

  ;My current method of cycle detection is to look for 15 highs in a row on
  ; the strobe line.  Cycle ends is detected by 15 lows in a row.
  ;Mode A has 15 strobes in a cycle, Mode B has 5.
  ; Note that the 15 highs/lows for cycle detection may be too high for slow
  ; machines.  I havn't seen a problem yet, but it may exist...

  FindCycle:
  mov al,cs:[gDump+di]        ;get next status byte
  inc di                      ;increment input pointer
  cmp di,200                  ;test for end of status block
  je SHORT SWNoFind           ;if it's the end, quit sub with error
  test al,00010000b           ;Check for nonzero bits
  jnz SHORT WMFCS1            ;
  xor cx,cx                   ;if zero, reset tick count
  jmp SHORT FindCycle         ;can't be pre-cycle
  WMFCS1:                     ;Possibly pre-cycle
  inc cx                      ;increment tick count
  cmp cx,15                   ;test for sufficient ticks for cycle start
  jne SHORT FindCycle         ;if insufficient, get next status byte
                              ;Yippie! it found a (probable) cycle!

  mov bp,0                    ;initialize bDump index

  FindStrobeLow:              ;Search for leading edge of data strobe
  mov al,cs:[gDump+di]        ;get next status byte
  inc di                      ;increment input pointer
  cmp di,200                  ;test for end of status block
  je SHORT SWNoFind           ;if it's the end, quit sub with error
  test al,00010000b           ;get "strobe" bit
  jnz SHORT FindStrobeLow     ;if it isn't zero, we're not there yet
  xor cx,cx                   ;initialize cycle end test count

  FindStrobeHigh:
  inc cx                      ;increment zero count
  cmp cx,0fh                  ;is it 15?
  je SWModeBCheck             ;if so, goto mode B check
  mov al,cs:[gDump+di]        ;get next status byte
  inc di                      ;increment input pointer
  cmp di,200                  ;test for end of status block
  je SHORT SWNoFind           ;if it's the end, quit sub with error
  test al,00010000b           ;get "strobe" bit
  jz SHORT FindStrobeHigh     ;if it is zero, we're not there yet
                              ;if not, we're there!  data bit is valid (probably)
  mov CS:[bDump+bp],al        ;preserve data for mode B
  inc bp                      ;increment cycle count/bDump index
  shl si,1                    ;set next output bit (mode A)
  test al,00100000b           ;test for button press (mode A)
  jnz SHORT NoButton          ;Button not pressed, so wait for next button
  or bx,si                    ;Button IS pressed, or the bit into the output
  NoButton:
  cmp bp,15                   ;Is Mode A done?
  je SHORT SMWDone            ;
  jmp SHORT FindStrobeLow     ;if it isn't, wait for the next button

  SMWDone:
  pop bp
  pop di
  pop si
  pop dx
  pop cx
  pop ax                      ;restore registers
  clc                         ;indicate no error
  ret                         ;return to calling procedure
  SWNoFind:
  ;error return.  Calling sub should re-dump status, or report "no sidewinder"
  pop bp
  pop di
  pop si
  pop dx
  pop cx
  pop ax                      ;restore registers
  stc                         ;indicate error
  ret
  SWModeBCheck:
  cmp bp,5                    ;Check strobe count (Mode B always has five)
  jne SHORT SWNoFind
  ;Handle mode B buttons
  mov bx,0                    ;Initialize output
  test CS:[bDump],00100000b   ;Check bit 5 of Cycle 0
  jnz NoUp                    ;if zero, up is not pressed
  or bx,0000000000000010b     ;set Up bit in output
  NoUp:                       ;
  test CS:[bDump],01000000b   ;continues the same for all buttons.
  jnz NoDn
  or bx,0000000000000100b
  NoDn:
  test CS:[bDump],10000000b
  jnz NoRt
  or bx,0000000000001000b
  NoRt:
  test CS:[bDump+1],00100000b
  jnz NoLt
  or bx,0000000000010000b
  NoLt:
  test CS:[bDump+1],01000000b
  jnz NoA
  or bx,0000000000100000b
  NoA:
  test CS:[bDump+1],10000000b
  jnz NoB
  or bx,0000000001000000b
  NoB:
  test CS:[bDump+2],00100000b
  jnz NoC
  or bx,0000000010000000b
  NoC:
  test CS:[bDump+2],01000000b
  jnz NoX
  or bx,0000000100000000b
  NoX:
  test CS:[bDump+2],10000000b
  jnz NoY
  or bx,0000001000000000b
  NoY:
  test CS:[bDump+3],00100000b
  jnz NoZ
  or bx,0000010000000000b
  NoZ:
  test CS:[bDump+3],01000000b
  jnz NoL
  or bx,0000100000000000b
  NoL:
  test CS:[bDump+3],10000000b
  jnz NoR
  or bx,0001000000000000b
  NoR:
  test CS:[bDump+4],00100000b
  jnz NoSt
  or bx,0010000000000000b
  NoSt:
  test CS:[bDump+4],01000000b
  jnz NoM
  or bx,0100000000000000b
  NoM:
  test CS:[bDump+4],10000000b
  jnz NoParity
  or bx,1000000000000000b
  NoParity:
  jmp SMWDone
ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;	End resident section
;;
;;	The rest of this code is discarded on installation as a TSR, and
;;	does not consume additional memory
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Installation messages

msg_instald  db 7,'Sidewinder TSR is already installed',13,10,'$'
msg_instnot  db 7,'Sidewinder TSR is not installed',13,10,'$'
msg_instok   db 'Sidewinder TSR is now active',13,10,'$'
msg_inval    db 7,'Invalid command line option',13,10,'$'
msg_unloaded db 'Sidewinder TSR successfully unloaded',13,10,'$'
msg_start    db 'Sidewinder TSR Version 1.0',13,10
             db 'Copyright (C) 1997  Robert William Grubbs',13,10
             db '$'

; ----------------------
; Installation procedure
; ----------------------

install PROC NEAR
	assume ds:_code				; DS = CS by default
	mov DX,offset msg_start			; Output our logo
	mov AH,9
	int DOS
	cld					; Required for string opcodes
	mov SI,81H				; Start of command line
@Top:
	lodsb
	cmp AL,13				; Test for end of cmdline
	je @Load
	cmp AL,0
	je @Load
	cmp AL,32				; Skip spaces,
	je @Top
	cmp AL,9				; and tabs
	je @Top
	cmp AL,'/'				; Looking for a valid switch
	je @F					; character (- or / will do)
	cmp AL,'-'
	je @F
@nogood:
	mov AL,3				; Something else is invalid
	mov DX,offset msg_inval
	jmp ExitMsg
;
; Read switch value
;
@@:
	lodsb
	cmp AL,'a'				; Convert to uppercase
	jb @F
	cmp AL,'z'
	ja @F
	sub AL,'a'-'A'
@@:
	cmp AL,'U'				; /U = Uninstall
	je @Unload
	jmp SHORT @Top

;
; Unload from memory
;

@Unload:
        call ChkLoad                            ; See if SIDEWTSR is loaded
        cmp ES:[BX+6],CDSIG                     ; Is this program installed?
	mov DX,offset msg_instnot
	mov AL,2
	jne ExitMsg
	push DS					; Preserve DS for later
	push ES
	pop DS
	mov DX,word ptr [oldvec]
	mov DS,word ptr [oldvec+2]
        mov AX,2515H                            ; Release INT 14H
	int DOS
	pop DS
	mov AH,49H				; Deallocate memory (at ES)
	int DOS
	mov DX,offset msg_unloaded
	xor AL,AL
	jmp SHORT ExitMsg

;
; Load into memory
;

@Load:
	call ChkLoad				; Check to see if we're loaded
        cmp ES:[BX+6],CDSIG                     ; Is this program installed?
	mov DX,offset msg_instald
	mov AL,2
	je ExitMsg
        mov DX,offset Int_15                    ; Install vector for INT 14H
        mov AX,2515H
	int DOS
	mov AX,CS
	mov ES,AX
	mov ES,ES:[02cH]			; Free our environment
	mov AH,049H
	int DOS
	mov DX,offset msg_instok
	mov AH,09H				; Print message
	int DOS
        mov DX,offset msg_instald               ; Stay resident
	int TSR

install ENDP

;
; Exit (abort) with a message
;

ExitMsg	PROC NEAR

	push AX					; Save exit code
	mov AH,09H				; Print message
	int DOS
	pop AX
	mov AH,4cH				; And exit
	int DOS

ExitMsg ENDP

;
; Check to see if already loaded
;

ChkLoad PROC NEAR
        mov AX,3515H                            ; Get int 14H vector
	int DOS
	mov word ptr [oldvec],BX		; And save it
	mov word ptr [oldvec+2],ES
	ret
ChkLoad ENDP

_code ends

end start
